function h = enum(x,y,t,flag)
% h = enum(x,y,t)
% h = enum(x,y)
% h = enum(x,y,t,'simple')
% Texts numbers from T array at X and Y locations.
% If T is omited, just enumerates the (x,y) pairs as they go.
% If 'simple' is provided, it does not draw cream-colored circles, nor sets the axes limits.

% Aug 30 2014: Denan in the beginning.
% Jan 05 2015: Now it won't set HOLD to OFF as it used to do.

nextPlot = get(gca,'NextPlot'); % Maybe hold on was on?

if(~exist('t','var')); t=1:length(x); end;
flagSimple = 0;
if(exist('flag','var'))
    if(strcmp(flag,'simple'))
        flagSimple = 1;
    end
end

x = x(:); y = y(:); t = t(:); % All rows to columns.
good = ~isnan(x)&~isnan(y);
x = x(good); y = y(good); t = t(good);

hold on;
if(~flagSimple)
    plot(x,y,'o','MarkerEdgeColor',ones(3,1)*1,'MarkerFaceColor',[1 1 0.85],'MarkerSize',12);
end

if(iscell(t))
    arrayfun(@(x,y,t) text(x,y,t{:},'FontSize',8,'HorizontalAlignment','center'),x,y,t);
else
    arrayfun(@(x,y,t) text(x,y,num2str(t),'FontSize',8,'HorizontalAlignment','center'),x,y,t);
end
    
if(~flagSimple)
    [x1,x2,xtick] = tick_value(min(x),max(x));
    [y1,y2,ytick] = tick_value(min(y),max(y));
    set(gca,'XLim',[x1 x2],'YLim',[y1 y2]);
end
hold off;

set(gca,'NextPlot',nextPlot);   % Restore whatever condition was there
end